/******************************************************************************
 CSlots.c

				CSlots ArrayPane Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory) 9:07 PM Tue, Sep 28, 1993

	This file is only generated once. You can modify it by filling
	in the placeholder functions and adding any new functions you wish.

	If you change the name of the document class, a fresh version of this
	file will be generated. If you have made any changes to the file
	with the old name, you will have to copy those changes to the new
	file by hand.

 ******************************************************************************/

#include "CSlots.h"
#include "MacAdaLib.h"
#include <string.h>
#include <stdio.h>

/**** C O N S T R U C T I O N / D E S T R U C T I O N   M E T H O D S ****/


/******************************************************************************
 ICSlots

	Initialize the object

	IMPORTANT NOTE: When an object is initialized as part of a
	'CVue' resource, this I-function is NEVER CALLED. Instead,
	the object is initialized in its GetFrom method(s). To add your
	own initialization, override GetFrom.

 ******************************************************************************/

void	CSlots::ICSlots(
	CView			*anEnclosure,
	CBureaucrat		*aSupervisor,
	short			aWidth,
	short			aHeight,
	short			aHEncl,
	short			aVEncl,
	SizingOption	aHSizing,
	SizingOption	aVSizing)
{
	x_CSlots::Ix_CSlots(anEnclosure, aSupervisor,
					aWidth, aHeight, aHEncl, aVEncl, aHSizing, aVSizing);

		// Initialize your own data members below
	haveSlots = false;
}


/******************************************************************************
 SetSlot
 ******************************************************************************/

void	CSlots::SetSlots(LSlot c, LSlot d, LSlot e)
{
	short rowsInTable;
	short newRows;

	code = c;
	data = d;
	exception = e;
	haveSlots = true;

	rowsInTable = GetRowCount();
	newRows = code.numEntries + data.numEntries + exception.numEntries + 8;

	if (newRows > rowsInTable)
		AddRow(newRows - rowsInTable, -1);
	else if (newRows < rowsInTable)
		DeleteRow(rowsInTable - newRows, 0);


	// setup row indices for drawing
	rows[kCodeMTitle] = 0;
	rows[kCodeTitles] = rows[kCodeMTitle] + 1;
	rows[kCodeFirst] = rows[kCodeTitles] + 1;
	rows[kCodeLast] = rows[kCodeFirst] + code.numEntries - 1;
	rows[kBlank1] = rows[kCodeLast] + 1;

	rows[kDataMTitle] = rows[kBlank1] + 1;
	rows[kDataTitles] = rows[kDataMTitle] + 1;
	rows[kDataFirst] = rows[kDataTitles] + 1;
	rows[kDataLast] = rows[kDataFirst] + data.numEntries - 1;
	rows[kBlank2] = rows[kDataLast] + 1;

	rows[kExepMTitle] = rows[kBlank2] + 1;
	rows[kExepTitles] = rows[kExepMTitle] + 1;
	rows[kExepFirst] = rows[kExepTitles] + 1;
	rows[kExepLast] = rows[kExepFirst] + exception.numEntries - 1;

}


/******************************************************************************
 GetCellText
 ******************************************************************************/
void CSlots::GetCellText( Cell aCell, short availableWidth, StringPtr itsText)
{

	if (!haveSlots)
		inherited::GetCellText(aCell, availableWidth, itsText);

	else {
		register char *a;

		if (aCell.v == rows[kCodeMTitle])
			CopyPString("\p         CODE", itsText);
		else if (aCell.v == rows[kDataMTitle])
			CopyPString("\p         DATA", itsText);
		else if (aCell.v == rows[kExepMTitle])
			CopyPString("\p       EXCEPTIONS", itsText);
		

		else if ((aCell.v == rows[kCodeTitles]) ||
				 (aCell.v == rows[kDataTitles]) ||
				 (aCell.v == rows[kExepTitles]))
			CopyPString("\pNum   Seq   Unit   Name", itsText);

		else if ((aCell.v == rows[kBlank1]) ||
				 (aCell.v == rows[kBlank2]))
			CopyPString("\p", itsText);

		else if ((aCell.v >= rows[kCodeFirst]) &&
				 (aCell.v <= rows[kCodeLast]))
			BuildLine(code.entries[aCell.v - rows[kCodeFirst]], itsText);

		else if ((aCell.v >= rows[kDataFirst]) &&
				 (aCell.v <= rows[kDataLast]))
			BuildLine(data.entries[aCell.v - rows[kDataFirst]], itsText);

		else if ((aCell.v >= rows[kExepFirst]) &&
				 (aCell.v <= rows[kExepLast]))
			BuildLine(exception.entries[aCell.v - rows[kExepFirst]], itsText);

		else
			inherited::GetCellText(aCell, availableWidth, itsText);
	}
}


/******************************************************************************
 BuildLine
 ******************************************************************************/

void	CSlots::BuildLine(SlotEntry slot, StringPtr itsText)
{		// itsText is a pointer to a 255 char string

	if (slot.exists) {
		char *a;
		short len;
		char buff[10];

		memset(&itsText[1], ' ', 255);
		sprintf(buff, "%3d", slot.slot_number);
		BlockMove(buff, &itsText[1], 3);

		sprintf(buff, "%3d", slot.slot_seq);
		BlockMove(buff, &itsText[7], 3);

		sprintf(buff, "%3d", slot.slot_unit);
		BlockMove(buff, &itsText[13], 3);

		a = slot.slot_name;
		len = strlen(a);
		BlockMove(a, &itsText[20], len);
		itsText[0] = len + 20;
	}
	else {
		CopyPString("\pSlot does not exist", itsText);
	}
}
